/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.table;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.dialog.VWDataFieldItem;
import filenet.vw.toolkit.utils.table.VWQubbleSort;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class VWSortedListModel
extends DefaultListModel
implements Comparator {
    public int[] sort(int[] selectedIndices) {
        if (selectedIndices == null || selectedIndices.length == 0 || this.getSize() == 0) {
            return selectedIndices;
        }
        this.sort();
        Object[] items = this.toArray();
        int[] newIndices = new int[selectedIndices.length];
        for (int i = 0; i < selectedIndices.length; ++i) {
            int nIndex = selectedIndices[i];
            Object item = items[nIndex];
            newIndices[i] = this.indexOf(item);
        }
        return newIndices;
    }

    public void sort() {
        if (this.size() > 1) {
            try {
                Object[] items = this.toArray();
                items = this.sortArray(items);
                for (int nIndex = 0; nIndex < this.size(); ++nIndex) {
                    this.setElementAt(items[nIndex], nIndex);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
    }

    public Object[] sortArray(Object[] items) {
        if (items == null || items.length <= 1) {
            return items;
        }
        Vector<Object> itemList = new Vector<Object>();
        for (int nIndex = 0; nIndex < items.length; ++nIndex) {
            itemList.addElement(items[nIndex]);
        }
        Collections.sort(itemList, this);
        items = new Object[itemList.size()];
        itemList.copyInto(items);
        return items;
    }

    public int compare(Object obj1, Object obj2) {
        int nResult = VWQubbleSort.compareTo(obj1, obj2);
        if (nResult == 0 && obj1 instanceof VWDataFieldItem && obj2 instanceof VWDataFieldItem) {
            nResult = ((VWDataFieldItem)obj1).getType() == ((VWDataFieldItem)obj2).getType() ? 0 : 1;
        }
        return nResult;
    }
}

